<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>PhotoAid - Professional Passport Photos in 3 Seconds</title>
    <meta name="description" content="Get AI-powered passport and ID photos instantly. Government-approved, 100% acceptance guarantee.">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700;800;900&display=swap" rel="stylesheet">
    <style>
        /* PhotoAid - Light Theme Design System */
        :root {
            --background: hsl(0 0% 100%);
            --foreground: hsl(220 20% 10%);
            --card: hsl(0 0% 100%);
            --card-foreground: hsl(220 20% 10%);
            --primary: hsl(24 95% 53%);
            --primary-foreground: hsl(0 0% 100%);
            --secondary: hsl(220 14% 96%);
            --muted: hsl(220 14% 96%);
            --muted-foreground: hsl(220 10% 45%);
            --border: hsl(220 14% 90%);
            --radius: 1rem;
            --amber: hsl(38 92% 50%);
            --coral: hsl(12 90% 60%);
            --navy: hsl(220 40% 13%);
            --sky: hsl(200 80% 55%);
            --gradient-primary: linear-gradient(135deg, hsl(38 92% 50%), hsl(24 95% 53%), hsl(12 90% 60%));
            --gradient-hero: linear-gradient(180deg, hsl(220 14% 98%) 0%, hsl(0 0% 100%) 100%);
            --gradient-glass: linear-gradient(135deg, hsla(0, 0%, 100%, 0.9) 0%, hsla(0, 0%, 100%, 0.7) 100%);
            --shadow-sm: 0 2px 8px -2px hsla(220, 20%, 10%, 0.08);
            --shadow-md: 0 8px 24px -8px hsla(220, 20%, 10%, 0.12);
            --shadow-lg: 0 20px 40px -12px hsla(220, 20%, 10%, 0.15);
            --shadow-glow: 0 0 40px -10px hsla(24, 95%, 53%, 0.4);
        }
        
        * { margin: 0; padding: 0; box-sizing: border-box; }
        html { scroll-behavior: smooth; }
        body {
            font-family: 'Inter', system-ui, sans-serif;
            background: var(--background);
            color: var(--foreground);
            -webkit-font-smoothing: antialiased;
            line-height: 1.6;
        }
        
        .container { max-width: 1280px; margin: 0 auto; padding: 0 16px; }
        
        .gradient-text {
            background: var(--gradient-primary);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
        }
        
        /* ========== HEADER ========== */
        .header {
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            z-index: 50;
            background: var(--gradient-glass);
            backdrop-filter: blur(20px);
            -webkit-backdrop-filter: blur(20px);
            border-bottom: 1px solid var(--border);
        }
        .header-inner {
            display: flex;
            align-items: center;
            justify-content: space-between;
            height: 80px;
        }
        .logo {
            display: flex;
            align-items: center;
            gap: 8px;
            text-decoration: none;
            color: inherit;
        }
        .logo-icon {
            width: 40px;
            height: 40px;
            border-radius: 12px;
            background: var(--gradient-primary);
            display: flex;
            align-items: center;
            justify-content: center;
            box-shadow: var(--shadow-glow);
        }
        .logo-icon svg { width: 20px; height: 20px; color: white; }
        .logo-text { font-size: 20px; font-weight: 700; }
        
        .nav { display: flex; align-items: center; gap: 32px; }
        .nav a {
            font-size: 14px;
            font-weight: 500;
            color: var(--muted-foreground);
            text-decoration: none;
            transition: color 0.2s;
        }
        .nav a:hover { color: var(--foreground); }
        
        .header-buttons { display: flex; gap: 12px; }
        
        /* Buttons */
        .btn {
            display: inline-flex;
            align-items: center;
            justify-content: center;
            gap: 8px;
            font-size: 14px;
            font-weight: 600;
            padding: 10px 16px;
            border-radius: var(--radius);
            border: none;
            cursor: pointer;
            transition: all 0.2s;
            text-decoration: none;
        }
        .btn-ghost {
            background: transparent;
            color: var(--foreground);
        }
        .btn-ghost:hover { background: var(--muted); }
        .btn-primary {
            background: var(--gradient-primary);
            color: white;
        }
        .btn-primary:hover { opacity: 0.9; transform: translateY(-1px); }
        .btn-lg { padding: 16px 32px; font-size: 16px; height: 56px; }
        .btn-outline {
            background: transparent;
            border: 1px solid var(--border);
            color: var(--foreground);
        }
        .btn-outline:hover { background: var(--muted); }
        .shadow-glow { box-shadow: var(--shadow-glow); }
        
        /* ========== HERO ========== */
        .hero {
            position: relative;
            padding: 128px 0 64px;
            overflow: hidden;
            background: var(--gradient-hero);
        }
        .hero-bg {
            position: absolute;
            inset: 0;
            pointer-events: none;
            overflow: hidden;
        }
        .hero-blob {
            position: absolute;
            border-radius: 50%;
            filter: blur(100px);
        }
        .hero-blob-1 {
            top: 80px;
            right: 25%;
            width: 288px;
            height: 288px;
            background: linear-gradient(135deg, hsla(38, 92%, 50%, 0.2), hsla(12, 90%, 60%, 0.2));
        }
        .hero-blob-2 {
            bottom: 80px;
            left: 25%;
            width: 384px;
            height: 384px;
            background: linear-gradient(135deg, hsla(200, 80%, 55%, 0.1), hsla(24, 95%, 55%, 0.1));
        }
        
        .hero-grid {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 64px;
            align-items: center;
            position: relative;
            z-index: 10;
        }
        
        .hero-badge {
            display: inline-flex;
            align-items: center;
            gap: 8px;
            padding: 8px 16px;
            border-radius: 50px;
            background: hsla(24, 95%, 53%, 0.1);
            color: var(--primary);
            font-size: 14px;
            font-weight: 500;
            margin-bottom: 24px;
        }
        
        .hero h1 {
            font-size: 60px;
            font-weight: 800;
            line-height: 1.1;
            margin-bottom: 24px;
            letter-spacing: -0.02em;
        }
        
        .hero-desc {
            font-size: 20px;
            color: var(--muted-foreground);
            margin-bottom: 32px;
            max-width: 500px;
            line-height: 1.6;
        }
        
        .hero-features {
            display: flex;
            flex-wrap: wrap;
            gap: 16px;
            margin-bottom: 32px;
        }
        .hero-feature {
            display: flex;
            align-items: center;
            gap: 8px;
            font-size: 14px;
            color: var(--muted-foreground);
        }
        .hero-feature svg { width: 16px; height: 16px; color: var(--primary); }
        
        .hero-buttons { display: flex; gap: 16px; margin-bottom: 40px; }
        
        .hero-trust {
            display: flex;
            align-items: center;
            gap: 24px;
        }
        .stars { color: var(--amber); font-size: 20px; letter-spacing: 2px; }
        .trust-text { font-size: 14px; }
        .trust-text strong { color: var(--foreground); }
        .trust-text span { color: var(--muted-foreground); }
        
        /* Hero Image */
        .hero-image-wrap {
            position: relative;
            max-width: 100%;
        }
        .hero-image-container {
            position: relative;
            border-radius: 24px;
            overflow: hidden;
            box-shadow: var(--shadow-lg);
        }
        .hero-image {
            width: 100%;
            height: auto;
            display: block;
        }
        .hero-image-overlay {
            position: absolute;
            inset: 0;
            background: linear-gradient(to top, hsla(220, 40%, 13%, 0.2), transparent);
        }
        
        .floating-card {
            position: absolute;
            background: var(--gradient-glass);
            backdrop-filter: blur(20px);
            border: 1px solid var(--border);
            border-radius: 16px;
            padding: 16px;
            display: flex;
            align-items: center;
            gap: 12px;
            box-shadow: var(--shadow-lg);
        }
        .floating-card-1 {
            top: 32px;
            right: -32px;
            animation: float1 4s ease-in-out infinite;
        }
        .floating-card-2 {
            bottom: 48px;
            left: -32px;
            animation: float2 5s ease-in-out infinite;
        }
        @keyframes float1 { 0%, 100% { transform: translateY(0); } 50% { transform: translateY(-10px); } }
        @keyframes float2 { 0%, 100% { transform: translateY(0); } 50% { transform: translateY(10px); } }
        
        .floating-icon {
            width: 40px;
            height: 40px;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
        }
        .floating-icon.green { background: hsla(142, 76%, 36%, 0.2); color: hsl(142, 76%, 36%); }
        .floating-icon.orange { background: hsla(24, 95%, 53%, 0.2); color: var(--primary); }
        .floating-text strong { display: block; font-size: 14px; font-weight: 600; }
        .floating-text span { font-size: 12px; color: var(--muted-foreground); }
        
        /* Featured */
        .featured {
            margin-top: 96px;
            text-align: center;
        }
        .featured p {
            font-size: 14px;
            color: var(--muted-foreground);
            margin-bottom: 32px;
        }
        .featured-logos {
            display: flex;
            justify-content: center;
            gap: 64px;
            flex-wrap: wrap;
            opacity: 0.6;
        }
        .featured-logos span {
            font-size: 24px;
            font-weight: 700;
            letter-spacing: -0.02em;
            color: var(--muted-foreground);
        }
        
        /* ========== SECTIONS ========== */
        .section { padding: 80px 0 128px; }
        .section-muted { background: var(--muted); }
        
        .section-header {
            text-align: center;
            margin-bottom: 64px;
        }
        .section-badge {
            font-size: 14px;
            font-weight: 600;
            text-transform: uppercase;
            letter-spacing: 0.1em;
            color: var(--primary);
            margin-bottom: 16px;
            display: block;
        }
        .section-header h2 {
            font-size: 48px;
            font-weight: 700;
            margin-bottom: 24px;
            letter-spacing: -0.02em;
        }
        .section-header p {
            font-size: 18px;
            color: var(--muted-foreground);
            max-width: 600px;
            margin: 0 auto;
        }
        
        /* How It Works */
        .steps-grid {
            display: grid;
            grid-template-columns: repeat(3, 1fr);
            gap: 48px;
        }
        .step-card {
            text-align: center;
            position: relative;
        }
        .step-number {
            position: absolute;
            top: -8px;
            left: 50%;
            transform: translateX(-50%);
            width: 32px;
            height: 32px;
            border-radius: 50%;
            background: var(--muted);
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 14px;
            font-weight: 700;
            z-index: 2;
        }
        .step-icon {
            width: 128px;
            height: 128px;
            margin: 16px auto 24px;
            border-radius: 24px;
            display: flex;
            align-items: center;
            justify-content: center;
        }
        .step-icon.sky { background: linear-gradient(135deg, hsla(200, 80%, 55%, 0.2), hsla(200, 80%, 55%, 0.05)); }
        .step-icon.orange { background: linear-gradient(135deg, hsla(24, 95%, 53%, 0.2), hsla(24, 95%, 53%, 0.05)); }
        .step-icon.coral { background: linear-gradient(135deg, hsla(12, 90%, 60%, 0.2), hsla(12, 90%, 60%, 0.05)); }
        .step-icon svg { width: 48px; height: 48px; }
        .step-icon.sky svg { color: var(--sky); }
        .step-icon.orange svg { color: var(--primary); }
        .step-icon.coral svg { color: var(--coral); }
        .step-card h3 { font-size: 20px; font-weight: 700; margin-bottom: 12px; }
        .step-card p { color: var(--muted-foreground); line-height: 1.6; }
        
        .step-card:not(:last-child)::after {
            content: '';
            position: absolute;
            top: 80px;
            left: 60%;
            width: 80%;
            border-top: 2px dashed var(--border);
        }
        
        /* Documents */
        .docs-grid {
            display: grid;
            grid-template-columns: repeat(4, 1fr);
            gap: 16px;
            max-width: 1000px;
            margin: 0 auto;
        }
        .doc-card {
            background: var(--card);
            border: 1px solid var(--border);
            border-radius: 16px;
            padding: 20px;
            display: flex;
            align-items: flex-start;
            gap: 12px;
            cursor: pointer;
            transition: all 0.2s;
            position: relative;
            text-decoration: none;
            color: inherit;
            box-shadow: var(--shadow-sm);
        }
        .doc-card:hover {
            border-color: var(--primary);
            transform: scale(1.02);
            box-shadow: var(--shadow-md);
        }
        .doc-icon {
            width: 40px;
            height: 56px;
            border-radius: 8px;
            background: linear-gradient(135deg, hsla(24, 95%, 53%, 0.1), hsla(12, 90%, 60%, 0.1));
            border: 2px solid var(--border);
            display: flex;
            align-items: center;
            justify-content: center;
            flex-shrink: 0;
        }
        .doc-icon-inner {
            width: 20px;
            height: 28px;
            border-radius: 4px;
            background: hsla(220, 10%, 45%, 0.2);
        }
        .doc-info h4 { font-size: 14px; font-weight: 600; margin-bottom: 2px; }
        .doc-info p { font-size: 12px; color: var(--muted-foreground); margin-bottom: 2px; }
        .doc-size { font-size: 10px; color: var(--muted-foreground); opacity: 0.7; }
        .doc-badge {
            position: absolute;
            top: 12px;
            right: 12px;
            font-size: 10px;
            font-weight: 600;
            padding: 2px 8px;
            border-radius: 50px;
            background: hsla(24, 95%, 53%, 0.1);
            color: var(--primary);
        }
        .doc-arrow {
            position: absolute;
            bottom: 16px;
            right: 16px;
            opacity: 0;
            transition: opacity 0.2s;
            color: var(--primary);
        }
        .doc-card:hover .doc-arrow { opacity: 1; }
        
        /* Pricing */
        .pricing-grid {
            display: grid;
            grid-template-columns: repeat(2, 1fr);
            gap: 32px;
            max-width: 750px;
            margin: 0 auto 64px;
        }
        .price-card {
            border-radius: 24px;
            padding: 32px;
            position: relative;
        }
        .price-card.light {
            background: var(--card);
            border: 1px solid var(--border);
            box-shadow: var(--shadow-sm);
        }
        .price-card.dark {
            background: var(--navy);
            color: white;
            box-shadow: var(--shadow-lg);
        }
        .price-badge {
            position: absolute;
            top: -12px;
            left: 50%;
            transform: translateX(-50%);
            background: var(--gradient-primary);
            color: white;
            font-size: 14px;
            font-weight: 600;
            padding: 6px 16px;
            border-radius: 50px;
            white-space: nowrap;
        }
        .price-card h3 { font-size: 24px; font-weight: 700; margin-bottom: 8px; margin-top: 8px; }
        .price-card .desc { font-size: 14px; color: var(--muted-foreground); margin-bottom: 24px; }
        .price-card.dark .desc { color: hsla(0, 0%, 100%, 0.7); }
        .price-amount { font-size: 48px; font-weight: 700; margin-bottom: 32px; }
        .price-features { list-style: none; margin-bottom: 32px; }
        .price-features li {
            display: flex;
            align-items: center;
            gap: 12px;
            padding: 8px 0;
            font-size: 14px;
            color: var(--muted-foreground);
        }
        .price-card.dark .price-features li { color: hsla(0, 0%, 100%, 0.9); }
        .price-features .check {
            width: 20px;
            height: 20px;
            border-radius: 50%;
            background: hsla(142, 76%, 36%, 0.1);
            display: flex;
            align-items: center;
            justify-content: center;
            flex-shrink: 0;
        }
        .price-card.dark .price-features .check { background: hsla(142, 76%, 36%, 0.2); }
        .price-features .check svg { width: 12px; height: 12px; color: hsl(142, 76%, 36%); }
        .price-card .btn { width: 100%; height: 48px; }
        .price-card.dark .btn {
            background: white;
            color: var(--navy);
        }
        .price-card.dark .btn:hover { background: hsla(0, 0%, 100%, 0.9); }
        
        /* Guarantees */
        .guarantees {
            display: grid;
            grid-template-columns: repeat(4, 1fr);
            gap: 24px;
            max-width: 900px;
            margin: 0 auto;
        }
        .guarantee {
            text-align: center;
        }
        .guarantee-icon {
            width: 48px;
            height: 48px;
            margin: 0 auto 12px;
            border-radius: 12px;
            background: hsla(24, 95%, 53%, 0.1);
            display: flex;
            align-items: center;
            justify-content: center;
        }
        .guarantee-icon svg { width: 20px; height: 20px; color: var(--primary); }
        .guarantee h4 { font-size: 14px; font-weight: 600; margin-bottom: 4px; }
        .guarantee p { font-size: 12px; color: var(--muted-foreground); }
        
        /* ========== FOOTER ========== */
        .footer {
            background: var(--muted);
            border-top: 1px solid var(--border);
            padding: 64px 0 0;
        }
        .footer-grid {
            display: grid;
            grid-template-columns: 2fr repeat(4, 1fr);
            gap: 48px;
            margin-bottom: 48px;
        }
        .footer-brand p {
            color: var(--muted-foreground);
            font-size: 14px;
            margin: 16px 0 24px;
            max-width: 300px;
        }
        .footer-social {
            display: flex;
            gap: 16px;
        }
        .footer-social a {
            width: 40px;
            height: 40px;
            border-radius: 8px;
            background: var(--background);
            display: flex;
            align-items: center;
            justify-content: center;
            color: var(--muted-foreground);
            text-decoration: none;
            font-size: 12px;
            font-weight: 700;
            transition: all 0.2s;
        }
        .footer-social a:hover {
            background: var(--border);
            color: var(--foreground);
        }
        .footer-col h4 {
            font-size: 14px;
            font-weight: 600;
            margin-bottom: 16px;
        }
        .footer-col a {
            display: block;
            padding: 6px 0;
            font-size: 14px;
            color: var(--muted-foreground);
            text-decoration: none;
            transition: color 0.2s;
        }
        .footer-col a:hover { color: var(--foreground); }
        .footer-bottom {
            border-top: 1px solid var(--border);
            padding: 32px 0;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }
        .footer-bottom p { font-size: 14px; color: var(--muted-foreground); }
        .footer-bottom-right {
            display: flex;
            gap: 24px;
            font-size: 14px;
            color: var(--muted-foreground);
        }
        
        /* ========== MODAL ========== */
        .modal-overlay {
            display: none;
            position: fixed;
            inset: 0;
            background: rgba(0, 0, 0, 0.5);
            z-index: 100;
            align-items: center;
            justify-content: center;
            padding: 20px;
        }
        .modal-overlay.active { display: flex; }
        .modal {
            background: var(--card);
            border: 1px solid var(--border);
            border-radius: 24px;
            width: 100%;
            max-width: 480px;
            padding: 32px;
            position: relative;
            box-shadow: var(--shadow-lg);
        }
        .modal-close {
            position: absolute;
            top: 16px;
            right: 16px;
            background: none;
            border: none;
            color: var(--muted-foreground);
            cursor: pointer;
            font-size: 24px;
        }
        .modal-spinner {
            width: 64px;
            height: 64px;
            border: 4px solid var(--border);
            border-top-color: var(--primary);
            border-radius: 50%;
            margin: 0 auto 24px;
            animation: spin 1s linear infinite;
        }
        @keyframes spin { to { transform: rotate(360deg); } }
        .modal h2 { font-size: 24px; font-weight: 700; text-align: center; margin-bottom: 8px; }
        .modal .subtitle { text-align: center; color: var(--muted-foreground); margin-bottom: 32px; }
        
        .steps-list { }
        .step-item {
            display: flex;
            align-items: center;
            gap: 16px;
            padding: 12px 0;
            border-bottom: 1px solid var(--border);
        }
        .step-item:last-child { border-bottom: none; }
        .step-indicator {
            width: 24px;
            height: 24px;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 12px;
            font-weight: 600;
            flex-shrink: 0;
        }
        .step-item.pending .step-indicator { background: var(--muted); color: var(--muted-foreground); }
        .step-item.active .step-indicator { background: var(--primary); color: white; animation: pulse 1s infinite; }
        .step-item.completed .step-indicator { background: hsl(142, 76%, 36%); color: white; }
        @keyframes pulse { 0%, 100% { transform: scale(1); } 50% { transform: scale(1.1); } }
        .step-item .step-text { font-size: 14px; color: var(--muted-foreground); }
        .step-item.active .step-text, .step-item.completed .step-text { color: var(--foreground); }
        
        .success-icon {
            width: 64px;
            height: 64px;
            border-radius: 50%;
            background: hsla(142, 76%, 36%, 0.2);
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 auto 16px;
        }
        .success-icon svg { width: 32px; height: 32px; color: hsl(142, 76%, 36%); }
        
        /* Results */
        .results-grid {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 32px;
            max-width: 900px;
            margin: 0 auto;
        }
        .photo-preview-card {
            background: var(--muted);
            border-radius: 16px;
            padding: 24px;
        }
        .photo-frame {
            position: relative;
            aspect-ratio: 35/45;
            border-radius: 12px;
            overflow: hidden;
            background: var(--border);
            margin-bottom: 16px;
        }
        .photo-frame img { width: 100%; height: 100%; object-fit: cover; }
        .watermark {
            position: absolute;
            inset: 0;
            display: flex;
            align-items: center;
            justify-content: center;
            background: repeating-linear-gradient(45deg, transparent, transparent 20px, hsla(24, 95%, 53%, 0.05) 20px, hsla(24, 95%, 53%, 0.05) 40px);
        }
        .watermark span {
            color: hsla(24, 95%, 53%, 0.5);
            font-size: 24px;
            font-weight: 800;
            transform: rotate(-30deg);
            text-transform: uppercase;
            letter-spacing: 4px;
        }
        .photo-specs {
            display: flex;
            justify-content: center;
            gap: 16px;
            font-size: 14px;
            color: var(--muted-foreground);
        }
        .photo-specs .dot {
            width: 4px;
            height: 4px;
            border-radius: 50%;
            background: var(--muted-foreground);
            align-self: center;
        }
        
        .results-sidebar { display: flex; flex-direction: column; gap: 24px; }
        .verify-card {
            background: var(--card);
            border: 1px solid var(--border);
            border-radius: 16px;
            padding: 20px;
        }
        .verify-title {
            display: flex;
            align-items: center;
            gap: 8px;
            font-weight: 600;
            margin-bottom: 16px;
        }
        .verify-title svg { width: 16px; height: 16px; color: var(--primary); }
        .verify-checks {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 12px;
        }
        .verify-check {
            display: flex;
            align-items: center;
            gap: 8px;
            font-size: 14px;
        }
        .verify-check svg { width: 16px; height: 16px; color: hsl(142, 76%, 36%); }
        
        .action-buttons { display: flex; flex-direction: column; gap: 12px; }
        .action-buttons .btn { width: 100%; justify-content: center; }
        
        .trust-row {
            display: flex;
            justify-content: center;
            gap: 24px;
            padding-top: 16px;
            border-top: 1px solid var(--border);
        }
        .trust-item {
            display: flex;
            align-items: center;
            gap: 8px;
            font-size: 14px;
            color: var(--muted-foreground);
        }
        .trust-item svg { width: 16px; height: 16px; }
        .trust-item svg.green { color: hsl(142, 76%, 36%); }
        .trust-item svg.orange { color: var(--primary); }
        
        .email-form {
            background: var(--muted);
            border-radius: 12px;
            padding: 20px;
            margin-top: 16px;
            display: none;
        }
        .email-form.active { display: block; }
        .email-form label {
            display: block;
            font-size: 14px;
            font-weight: 500;
            margin-bottom: 8px;
        }
        .email-form input {
            width: 100%;
            padding: 12px 16px;
            font-size: 15px;
            border: 1px solid var(--border);
            border-radius: 12px;
            background: var(--card);
            color: var(--foreground);
            margin-bottom: 12px;
        }
        .email-form input:focus {
            outline: none;
            border-color: var(--primary);
        }
        
        /* Responsive */
        @media (max-width: 1024px) {
            .hero-grid { grid-template-columns: 1fr; text-align: center; }
            .hero-content { order: 1; }
            .hero-image-wrap { order: 0; max-width: 400px; margin: 0 auto; }
            .hero-features { justify-content: center; }
            .hero-buttons { justify-content: center; }
            .hero-trust { justify-content: center; }
            .hero h1 { font-size: 40px; }
            .floating-card-1 { right: -16px; }
            .floating-card-2 { left: -16px; }
        }
        @media (max-width: 768px) {
            .nav, .header-buttons { display: none; }
            .steps-grid { grid-template-columns: 1fr; }
            .step-card::after { display: none; }
            .docs-grid { grid-template-columns: repeat(2, 1fr); }
            .pricing-grid { grid-template-columns: 1fr; }
            .guarantees { grid-template-columns: repeat(2, 1fr); }
            .footer-grid { grid-template-columns: 1fr 1fr; }
            .results-grid { grid-template-columns: 1fr; }
            .section-header h2 { font-size: 32px; }
        }
        
        .file-input { display: none; }
    </style>
</head>
<body>
    <!-- Header -->
    <header class="header">
        <div class="container header-inner">
            <a href="/" class="logo">
                <div class="logo-icon">
                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M14.5 4h-5L7 7H4a2 2 0 0 0-2 2v9a2 2 0 0 0 2 2h16a2 2 0 0 0 2-2V9a2 2 0 0 0-2-2h-3l-2.5-3z"/><circle cx="12" cy="13" r="3"/></svg>
                </div>
                <span class="logo-text">photo<span class="gradient-text">Aid</span></span>
            </a>
            <nav class="nav">
                <a href="#how-it-works">How it works</a>
                <a href="#documents">UK Documents</a>
                <a href="#pricing">Pricing</a>
                <a href="#faq">FAQ</a>
            </nav>
            <div class="header-buttons">
                <button class="btn btn-ghost">Log in</button>
                <button class="btn btn-primary shadow-glow">Get started</button>
            </div>
        </div>
    </header>

    <!-- Hero -->
    <section class="hero">
        <div class="hero-bg">
            <div class="hero-blob hero-blob-1"></div>
            <div class="hero-blob hero-blob-2"></div>
        </div>
        <div class="container hero-grid">
            <div class="hero-content">
                <div class="hero-badge">
                    <svg width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><path d="M12 3l1.5 4.5L18 9l-4.5 1.5L12 15l-1.5-4.5L6 9l4.5-1.5L12 3z"/></svg>
                    AI-Powered Photo Processing
                </div>
                <h1>UK passport photos <span class="gradient-text">in 3 seconds</span></h1>
                <p class="hero-desc">Get HMPO-compliant passport and ID photos instantly. AI-verified, government-approved, delivered to your door.</p>
                
                <div class="hero-features">
                    <div class="hero-feature">
                        <svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><path d="M22 11.08V12a10 10 0 1 1-5.93-9.14"/><polyline points="22 4 12 14.01 9 11.01"/></svg>
                        100% Acceptance Guarantee
                    </div>
                    <div class="hero-feature">
                        <svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><path d="M22 11.08V12a10 10 0 1 1-5.93-9.14"/><polyline points="22 4 12 14.01 9 11.01"/></svg>
                        Instant Digital Delivery
                    </div>
                    <div class="hero-feature">
                        <svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><path d="M22 11.08V12a10 10 0 1 1-5.93-9.14"/><polyline points="22 4 12 14.01 9 11.01"/></svg>
                        Print & Digital Options
                    </div>
                </div>
                
                <div class="hero-buttons">
                    <button class="btn btn-primary btn-lg shadow-glow" onclick="document.getElementById('fileInput').click()">
                        <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><path d="M21 15v4a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2v-4"/><polyline points="17 8 12 3 7 8"/><line x1="12" y1="3" x2="12" y2="15"/></svg>
                        Upload your photo
                    </button>
                    <button class="btn btn-outline btn-lg" onclick="document.getElementById('fileInput').click()">
                        <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><path d="M14.5 4h-5L7 7H4a2 2 0 0 0-2 2v9a2 2 0 0 0 2 2h16a2 2 0 0 0 2-2V9a2 2 0 0 0-2-2h-3l-2.5-3z"/><circle cx="12" cy="13" r="3"/></svg>
                        Take a photo
                    </button>
                </div>
                <input type="file" id="fileInput" class="file-input" accept="image/*" onchange="handleFileSelect(event)">
                
                <div class="hero-trust">
                    <div class="stars">★★★★★</div>
                    <div class="trust-text"><strong>4.9/5</strong> <span>from 50,000+ reviews</span></div>
                </div>
            </div>
            
            <div class="hero-image-wrap">
                <div class="hero-image-container">
                    <img src="assets/hero-passport-photo.jpg" alt="Passport photo" class="hero-image">
                    <div class="hero-image-overlay"></div>
                </div>
                <div class="floating-card floating-card-1">
                    <div class="floating-icon green">
                        <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><path d="M22 11.08V12a10 10 0 1 1-5.93-9.14"/><polyline points="22 4 12 14.01 9 11.01"/></svg>
                    </div>
                    <div class="floating-text">
                        <strong>AI Verified</strong>
                        <span>Photo approved</span>
                    </div>
                </div>
                <div class="floating-card floating-card-2">
                    <div class="floating-icon orange">
                        <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><path d="M12 3l1.5 4.5L18 9l-4.5 1.5L12 15l-1.5-4.5L6 9l4.5-1.5L12 3z"/></svg>
                    </div>
                    <div class="floating-text">
                        <strong>3 seconds</strong>
                        <span>Processing time</span>
                    </div>
                </div>
            </div>
        </div>
        
        <div class="container featured">
            <p>Featured in</p>
            <div class="featured-logos">
                <span>BBC</span>
                <span>Forbes</span>
                <span>HuffPost</span>
                <span>TechCrunch</span>
                <span>Daily Mail</span>
            </div>
        </div>
    </section>

    <!-- How It Works -->
    <section id="how-it-works" class="section">
        <div class="container">
            <div class="section-header">
                <span class="section-badge">How it works</span>
                <h2>Get your photo in <span class="gradient-text">3 easy steps</span></h2>
                <p>No studio appointments, no waiting in line. Create professional passport photos from anywhere in minutes.</p>
            </div>
            <div class="steps-grid">
                <div class="step-card">
                    <div class="step-number">1</div>
                    <div class="step-icon sky">
                        <svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><path d="M14.5 4h-5L7 7H4a2 2 0 0 0-2 2v9a2 2 0 0 0 2 2h16a2 2 0 0 0 2-2V9a2 2 0 0 0-2-2h-3l-2.5-3z"/><circle cx="12" cy="13" r="3"/></svg>
                    </div>
                    <h3>Take a photo</h3>
                    <p>Use your smartphone camera to take a quick selfie against any background.</p>
                </div>
                <div class="step-card">
                    <div class="step-number">2</div>
                    <div class="step-icon orange">
                        <svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><path d="M15 4V2"/><path d="M15 16v-2"/><path d="M8 9h2"/><path d="M20 9h2"/><path d="M17.8 11.8 19 13"/><path d="M15 9h0"/><path d="M17.8 6.2 19 5"/><path d="m3 21 9-9"/><path d="M12.2 6.2 11 5"/></svg>
                    </div>
                    <h3>AI processes it</h3>
                    <p>Our AI automatically removes background, adjusts lighting, and ensures compliance.</p>
                </div>
                <div class="step-card">
                    <div class="step-number">3</div>
                    <div class="step-icon coral">
                        <svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><path d="M21 15v4a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2v-4"/><polyline points="7 10 12 15 17 10"/><line x1="12" y1="15" x2="12" y2="3"/></svg>
                    </div>
                    <h3>Get your photo</h3>
                    <p>Download instantly or have prints delivered to your doorstep within 24 hours.</p>
                </div>
            </div>
        </div>
    </section>

    <!-- Documents -->
    <section id="documents" class="section section-muted">
        <div class="container">
            <div class="section-header">
                <span class="section-badge">UK Documents</span>
                <h2>Photos for all <span class="gradient-text">UK documents</span></h2>
                <p>Government-approved photos that meet all official UK requirements. 100% acceptance guaranteed.</p>
            </div>
            <div class="docs-grid">
                <div class="doc-card" onclick="selectDocument('uk_passport')">
                    <div class="doc-icon"><div class="doc-icon-inner"></div></div>
                    <div class="doc-info">
                        <h4>UK Passport</h4>
                        <p>Standard adult & child passport</p>
                        <span class="doc-size">35×45mm</span>
                    </div>
                    <span class="doc-badge">Popular</span>
                    <svg class="doc-arrow" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><polyline points="9 18 15 12 9 6"/></svg>
                </div>
                <div class="doc-card" onclick="selectDocument('uk_driving')">
                    <div class="doc-icon"><div class="doc-icon-inner"></div></div>
                    <div class="doc-info">
                        <h4>UK Driving Licence</h4>
                        <p>DVLA photo card licence</p>
                        <span class="doc-size">35×45mm</span>
                    </div>
                    <span class="doc-badge">Popular</span>
                    <svg class="doc-arrow" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><polyline points="9 18 15 12 9 6"/></svg>
                </div>
                <div class="doc-card" onclick="selectDocument('uk_visa')">
                    <div class="doc-icon"><div class="doc-icon-inner"></div></div>
                    <div class="doc-info">
                        <h4>UK Visa</h4>
                        <p>All UK visa applications</p>
                        <span class="doc-size">35×45mm</span>
                    </div>
                    <svg class="doc-arrow" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><polyline points="9 18 15 12 9 6"/></svg>
                </div>
                <div class="doc-card" onclick="selectDocument('eu_passport')">
                    <div class="doc-icon"><div class="doc-icon-inner"></div></div>
                    <div class="doc-info">
                        <h4>EU/Schengen</h4>
                        <p>European passport</p>
                        <span class="doc-size">35×45mm</span>
                    </div>
                    <svg class="doc-arrow" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><polyline points="9 18 15 12 9 6"/></svg>
                </div>
                <div class="doc-card" onclick="selectDocument('us_passport')">
                    <div class="doc-icon"><div class="doc-icon-inner"></div></div>
                    <div class="doc-info">
                        <h4>US Passport</h4>
                        <p>American passport</p>
                        <span class="doc-size">2×2 inch</span>
                    </div>
                    <svg class="doc-arrow" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><polyline points="9 18 15 12 9 6"/></svg>
                </div>
                <div class="doc-card" onclick="selectDocument('canada_passport')">
                    <div class="doc-icon"><div class="doc-icon-inner"></div></div>
                    <div class="doc-info">
                        <h4>Canadian Passport</h4>
                        <p>Canadian passport</p>
                        <span class="doc-size">50×70mm</span>
                    </div>
                    <svg class="doc-arrow" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><polyline points="9 18 15 12 9 6"/></svg>
                </div>
                <div class="doc-card" onclick="selectDocument('uk_passport')">
                    <div class="doc-icon"><div class="doc-icon-inner"></div></div>
                    <div class="doc-info">
                        <h4>UK Oyster Card</h4>
                        <p>TfL photocard</p>
                        <span class="doc-size">35×45mm</span>
                    </div>
                    <svg class="doc-arrow" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><polyline points="9 18 15 12 9 6"/></svg>
                </div>
                <div class="doc-card" onclick="selectDocument('uk_passport')">
                    <div class="doc-icon"><div class="doc-icon-inner"></div></div>
                    <div class="doc-info">
                        <h4>UK Blue Badge</h4>
                        <p>Disabled parking permit</p>
                        <span class="doc-size">35×45mm</span>
                    </div>
                    <svg class="doc-arrow" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><polyline points="9 18 15 12 9 6"/></svg>
                </div>
            </div>
            <p style="text-align:center;margin-top:32px;font-size:14px;color:var(--muted-foreground);">All photos meet official HMPO & DVLA requirements</p>
        </div>
    </section>

    <!-- Pricing -->
    <section id="pricing" class="section">
        <div class="container">
            <div class="section-header">
                <span class="section-badge">Pricing</span>
                <h2>Simple, <span class="gradient-text">transparent</span> pricing</h2>
                <p>No hidden fees. No subscriptions. Just pay for what you need.</p>
            </div>
            <div class="pricing-grid">
                <div class="price-card light">
                    <h3>Digital Only</h3>
                    <p class="desc">Perfect for quick online applications</p>
                    <div class="price-amount">£2.99</div>
                    <ul class="price-features">
                        <li><span class="check"><svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="3"><polyline points="20 6 9 17 4 12"/></svg></span>Instant digital download</li>
                        <li><span class="check"><svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="3"><polyline points="20 6 9 17 4 12"/></svg></span>AI background removal</li>
                        <li><span class="check"><svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="3"><polyline points="20 6 9 17 4 12"/></svg></span>Multiple formats (JPEG, PNG)</li>
                        <li><span class="check"><svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="3"><polyline points="20 6 9 17 4 12"/></svg></span>Unlimited retakes</li>
                        <li><span class="check"><svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="3"><polyline points="20 6 9 17 4 12"/></svg></span>Email delivery</li>
                    </ul>
                    <button class="btn btn-primary shadow-glow">Get Digital <svg width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><polyline points="9 18 15 12 9 6"/></svg></button>
                </div>
                <div class="price-card dark">
                    <span class="price-badge">Most Popular</span>
                    <h3>Digital + Print</h3>
                    <p class="desc">Most popular for passport renewals</p>
                    <div class="price-amount">£5.99</div>
                    <ul class="price-features">
                        <li><span class="check"><svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="3"><polyline points="20 6 9 17 4 12"/></svg></span>Everything in Digital Only</li>
                        <li><span class="check"><svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="3"><polyline points="20 6 9 17 4 12"/></svg></span>4 professional prints</li>
                        <li><span class="check"><svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="3"><polyline points="20 6 9 17 4 12"/></svg></span>Premium photo paper</li>
                        <li><span class="check"><svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="3"><polyline points="20 6 9 17 4 12"/></svg></span>Free standard shipping</li>
                        <li><span class="check"><svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="3"><polyline points="20 6 9 17 4 12"/></svg></span>Tracking included</li>
                    </ul>
                    <button class="btn">Get Digital + Print <svg width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><polyline points="9 18 15 12 9 6"/></svg></button>
                </div>
            </div>
            <div class="guarantees">
                <div class="guarantee">
                    <div class="guarantee-icon"><svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><path d="M12 22s8-4 8-10V5l-8-3-8 3v7c0 6 8 10 8 10z"/></svg></div>
                    <h4>100% Acceptance Guarantee</h4>
                    <p>Accepted by HMPO or full refund</p>
                </div>
                <div class="guarantee">
                    <div class="guarantee-icon"><svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><path d="M21 2v6h-6"/><path d="M3 12a9 9 0 0 1 15-6.7L21 8"/><path d="M3 22v-6h6"/><path d="M21 12a9 9 0 0 1-15 6.7L3 16"/></svg></div>
                    <h4>Unlimited Retakes</h4>
                    <p>Until you're completely satisfied</p>
                </div>
                <div class="guarantee">
                    <div class="guarantee-icon"><svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><circle cx="12" cy="12" r="10"/><polyline points="12 6 12 12 16 14"/></svg></div>
                    <h4>3-Second Processing</h4>
                    <p>AI-powered instant results</p>
                </div>
                <div class="guarantee">
                    <div class="guarantee-icon"><svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><circle cx="12" cy="8" r="7"/><polyline points="8.21 13.89 7 23 12 20 17 23 15.79 13.88"/></svg></div>
                    <h4>HMPO Approved</h4>
                    <p>Meets all UK requirements</p>
                </div>
            </div>
        </div>
    </section>

    <!-- Footer -->
    <footer class="footer">
        <div class="container">
            <div class="footer-grid">
                <div class="footer-brand">
                    <a href="/" class="logo">
                        <div class="logo-icon">
                            <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><path d="M14.5 4h-5L7 7H4a2 2 0 0 0-2 2v9a2 2 0 0 0 2 2h16a2 2 0 0 0 2-2V9a2 2 0 0 0-2-2h-3l-2.5-3z"/><circle cx="12" cy="13" r="3"/></svg>
                        </div>
                        <span class="logo-text">photo<span class="gradient-text">Aid</span></span>
                    </a>
                    <p>The world's leading passport photo service. Get professional, compliant photos in seconds.</p>
                    <div class="footer-social">
                        <a href="#">T</a>
                        <a href="#">F</a>
                        <a href="#">I</a>
                        <a href="#">L</a>
                    </div>
                </div>
                <div class="footer-col">
                    <h4>Product</h4>
                    <a href="#">How it works</a>
                    <a href="#">Pricing</a>
                    <a href="#">Documents</a>
                    <a href="#">Mobile App</a>
                </div>
                <div class="footer-col">
                    <h4>Resources</h4>
                    <a href="#">Help Center</a>
                    <a href="#">Blog</a>
                    <a href="#">Requirements Guide</a>
                    <a href="#">API</a>
                </div>
                <div class="footer-col">
                    <h4>Company</h4>
                    <a href="#">About Us</a>
                    <a href="#">Careers</a>
                    <a href="#">Press</a>
                    <a href="#">Contact</a>
                </div>
                <div class="footer-col">
                    <h4>Legal</h4>
                    <a href="#">Privacy Policy</a>
                    <a href="#">Terms of Service</a>
                    <a href="#">Cookie Policy</a>
                    <a href="#">GDPR</a>
                </div>
            </div>
            <div class="footer-bottom">
                <p>© 2025 PhotoAid. All rights reserved.</p>
                <div class="footer-bottom-right">
                    <span>🇬🇧 United Kingdom</span>
                    <span>English</span>
                </div>
            </div>
        </div>
    </footer>

    <script src="app.js"></script>
</body>
</html>
