/**
 * PhotoAid - Application JavaScript
 * Handles file upload and redirects to processing page
 */

let selectedDocument = 'uk_passport';

function selectDocument(docType) {
    selectedDocument = docType;
    document.getElementById('fileInput').click();
}

function handleFileSelect(event) {
    const file = event.target.files[0];
    if (!file) return;
    
    if (!file.type.startsWith('image/')) {
        alert('Please select an image file');
        return;
    }
    
    // Convert file to base64 and store in sessionStorage
    const reader = new FileReader();
    reader.onload = function(e) {
        sessionStorage.setItem('uploadedFile', e.target.result);
        sessionStorage.setItem('documentType', selectedDocument);
        
        // Redirect to processing page
        window.location.href = 'processing.php';
    };
    reader.readAsDataURL(file);
}
