<?php
/**
 * Email Service - MailerSend API
 * Professional light theme email
 */

class EmailService {
    
    private static $apiKey = 'mlsn.c12270c2df9ba23fce9ea1dbdefcb64cf2f11c42c612f7e474937cccd921ef95';
    private static $apiUrl = 'https://api.mailersend.com/v1/email';
    private static $fromEmail = 'support@profitsweep.com';
    private static $fromName = 'PhotoAid';
    
    /**
     * Send passport photos via MailerSend
     */
    public static function sendPhotos($to, $attachments, $documentType = 'Passport') {
        
        // Build attachments array
        $attachmentsData = [];
        foreach ($attachments as $name => $path) {
            if (file_exists($path)) {
                $content = base64_encode(file_get_contents($path));
                $filename = is_string($name) ? $name : basename($path);
                
                $attachmentsData[] = [
                    'filename' => $filename,
                    'content' => $content,
                    'disposition' => 'attachment'
                ];
            }
        }
        
        // Build email payload
        $payload = [
            'from' => [
                'email' => self::$fromEmail,
                'name' => self::$fromName
            ],
            'to' => [
                [
                    'email' => $to
                ]
            ],
            'subject' => "Your {$documentType} Photos - PhotoAid",
            'html' => self::getEmailTemplate($documentType),
            'text' => "Your {$documentType} photos are attached. Thank you for using PhotoAid!",
            'attachments' => $attachmentsData
        ];
        
        // Send via MailerSend API
        $ch = curl_init(self::$apiUrl);
        
        curl_setopt_array($ch, [
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_POST => true,
            CURLOPT_POSTFIELDS => json_encode($payload),
            CURLOPT_HTTPHEADER => [
                'Content-Type: application/json',
                'Authorization: Bearer ' . self::$apiKey,
                'X-Requested-With: XMLHttpRequest'
            ],
            CURLOPT_TIMEOUT => 30
        ]);
        
        $response = curl_exec($ch);
        $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        $error = curl_error($ch);
        curl_close($ch);
        
        if ($error) {
            return ['success' => false, 'error' => 'Connection error: ' . $error];
        }
        
        // MailerSend returns 202 for accepted
        if ($httpCode === 202 || $httpCode === 200) {
            return ['success' => true];
        }
        
        // Parse error response
        $responseData = json_decode($response, true);
        $errorMessage = $responseData['message'] ?? "HTTP {$httpCode}";
        
        return ['success' => false, 'error' => $errorMessage];
    }
    
    /**
     * Get professional light email HTML template
     */
    private static function getEmailTemplate($documentType) {
        return '
<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
</head>
<body style="margin:0;padding:0;font-family:-apple-system,BlinkMacSystemFont,\'Segoe UI\',Roboto,Helvetica,Arial,sans-serif;background-color:#f5f5f5;">
    <div style="max-width:600px;margin:0 auto;padding:40px 20px;">
        
        <!-- Header -->
        <div style="text-align:center;margin-bottom:32px;">
            <h1 style="margin:0;font-size:28px;font-weight:700;color:#1a1a1a;">
                photo<span style="background:linear-gradient(135deg,#f59e0b,#f97316,#ef4444);-webkit-background-clip:text;-webkit-text-fill-color:transparent;background-clip:text;">Aid</span>
            </h1>
        </div>
        
        <!-- Main Card -->
        <div style="background:#ffffff;border-radius:16px;padding:40px;box-shadow:0 4px 6px -1px rgba(0,0,0,0.1),0 2px 4px -1px rgba(0,0,0,0.06);">
            
            <!-- Success Icon -->
            <div style="text-align:center;margin-bottom:24px;">
                <div style="display:inline-block;width:64px;height:64px;background:#ecfdf5;border-radius:50%;line-height:64px;">
                    <span style="color:#10b981;font-size:32px;">✓</span>
                </div>
            </div>
            
            <!-- Title -->
            <h2 style="margin:0 0 8px 0;text-align:center;font-size:24px;font-weight:700;color:#1a1a1a;">Your photos are ready!</h2>
            <p style="margin:0 0 32px 0;text-align:center;font-size:16px;color:#6b7280;">AI-verified and government compliant</p>
            
            <!-- Document Type Box -->
            <div style="background:#f9fafb;border:1px solid #e5e7eb;border-radius:12px;padding:20px;margin-bottom:24px;text-align:center;">
                <p style="margin:0 0 4px 0;font-size:14px;color:#6b7280;">Document Type</p>
                <p style="margin:0;font-size:20px;font-weight:600;color:#1a1a1a;">' . htmlspecialchars($documentType) . '</p>
            </div>
            
            <!-- Verification Checks -->
            <div style="margin-bottom:24px;">
                <p style="margin:0 0 16px 0;font-size:16px;font-weight:600;color:#1a1a1a;">
                    <span style="color:#10b981;">✓</span> AI Verification Passed
                </p>
                <table style="width:100%;font-size:14px;color:#4b5563;">
                    <tr>
                        <td style="padding:6px 0;"><span style="color:#10b981;margin-right:8px;">✓</span>Face position</td>
                        <td style="padding:6px 0;"><span style="color:#10b981;margin-right:8px;">✓</span>Background</td>
                    </tr>
                    <tr>
                        <td style="padding:6px 0;"><span style="color:#10b981;margin-right:8px;">✓</span>Lighting</td>
                        <td style="padding:6px 0;"><span style="color:#10b981;margin-right:8px;">✓</span>Head size</td>
                    </tr>
                    <tr>
                        <td style="padding:6px 0;"><span style="color:#10b981;margin-right:8px;">✓</span>Expression</td>
                        <td style="padding:6px 0;"><span style="color:#10b981;margin-right:8px;">✓</span>Compliant</td>
                    </tr>
                </table>
            </div>
            
            <!-- Attachments Notice -->
            <div style="background:#fff7ed;border:1px solid #fed7aa;border-radius:12px;padding:20px;text-align:center;">
                <p style="margin:0 0 4px 0;font-size:16px;font-weight:600;color:#ea580c;">
                    📎 Your photos are attached
                </p>
                <p style="margin:0;font-size:14px;color:#9a3412;">
                    Single photo + Print-ready sheet included
                </p>
            </div>
            
        </div>
        
        <!-- Footer -->
        <div style="text-align:center;margin-top:32px;">
            <p style="margin:0 0 8px 0;font-size:14px;font-weight:500;color:#6b7280;">100% Acceptance Guarantee</p>
            <p style="margin:0;font-size:12px;color:#9ca3af;">© ' . date('Y') . ' PhotoAid. All rights reserved.</p>
        </div>
        
    </div>
</body>
</html>';
    }
}
